namespace BallDemo
{
    public class TextObject : IObject
    {
        public int Time { get; private set; }
        public int Speed { get; set; }
        public required string Text { get; set; }
        private Random random;
        public (int x, int y) pos;
        public TextObject()
        {
            this.random = new Random();
            this.Time = int.MaxValue;
        }
        public char? GetChar((int x, int y) pixel)
        {
            if (this.pos.y == pixel.y
                && pixel.x >= this.pos.x
            )
            {
                var diff = pixel.x - (int)this.pos.x;
                if(diff < Text.Length)
                {
                    return Text[diff];
                }
            }
            return null;
        }
        int tickSinceDirectionChange = 0;
        public void Run()
        {
            tickSinceDirectionChange++;

            this.pos.x -= this.Speed;
            if (random.Next(100) > 97)
            {
                this.pos.y = random.Next(Demo.Height);
            }
            if(random.Next(1000) > 998)
            {
                this.Speed *= -1;
                this.tickSinceDirectionChange = 0;
            }
            if (this.pos.x < 0 + this.Text.Length)
            {
                this.Time = 0;
            }
            if(tickSinceDirectionChange > 2 * Demo.RefreshRate)
            {
                this.Speed = Math.Max(this.Speed, this.Speed * -1);
            }
        }
    }
}